/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.container.AbstractModContainer;
import dev.toma.gunsrpg.common.container.SkilledWorkbenchContainer;
import dev.toma.gunsrpg.common.tileentity.ISkilledCrafting;
import dev.toma.gunsrpg.common.tileentity.VanillaInventoryTileEntity;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_RequestSkilledCraftPacket;
import dev.toma.gunsrpg.resource.crafting.SkilledRecipe;
import dev.toma.gunsrpg.resource.util.conditions.IRecipeCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SkilledWorkbenchScreen<T extends VanillaInventoryTileEntity, C extends SkilledWorkbenchContainer<T>>
extends ContainerScreen<C> {
    public static final ResourceLocation TEXTURE = GunsRPG.makeResource("textures/screen/skilled_workbench.png");
    private static final ITextComponent TEXT_CRAFT = new TranslationTextComponent("screen.button.craft");
    private static final ITextComponent INFO_LABEL = new TranslationTextComponent("screen.skilled_workbench.condition").func_240699_a_(TextFormatting.BOLD);
    private final T tile;
    private List<IRecipeCondition> failedChecks = Collections.emptyList();
    private Button craftButton;

    public SkilledWorkbenchScreen(C container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
        this.tile = (VanillaInventoryTileEntity)((Object)((AbstractModContainer)((Object)container)).getTileEntity());
        this.field_147000_g = 172;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ((ISkilledCrafting)this.tile).detachCallback();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.craftButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 7, this.field_147009_r + 65, 54, 20, TEXT_CRAFT, this::buttonCraft_Clicked));
        this.craftButton.field_230693_o_ = false;
        ((ISkilledCrafting)this.tile).detachCallback();
        ((ISkilledCrafting)this.tile).attachCallback(this::onRecipeChanged);
    }

    protected void func_230450_a_(MatrixStack stack, float partial, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        if (this.failedChecks.isEmpty()) {
            return;
        }
        CharacterManager splitter = this.field_230712_o_.func_238420_b_();
        LanguageMap map = LanguageMap.func_74808_a();
        ArrayList list = new ArrayList();
        for (IRecipeCondition condition : this.failedChecks) {
            StringTextComponent info = new StringTextComponent("- " + condition.getDisplayInfo().getString());
            splitter.func_238362_b_((ITextProperties)info, this.field_146999_f - 71, info.func_150256_b()).stream().map(arg_0 -> ((LanguageMap)map).func_241870_a(arg_0)).forEach(list::add);
        }
        int xPos = 66;
        int yPos = 88 - list.size() * 11;
        this.field_230712_o_.func_243248_b(stack, INFO_LABEL, (float)xPos, (float)(yPos - 11), 0x373737);
        int i = 0;
        for (IReorderingProcessor processor : list) {
            this.field_230712_o_.func_238422_b_(stack, processor, (float)xPos, (float)(yPos + 11 * i++), 0x373737);
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    private void buttonCraft_Clicked(Button button) {
        boolean shiftKey = Screen.func_231173_s_();
        NetworkManager.sendServerPacket(new C2S_RequestSkilledCraftPacket(this.tile.func_174877_v(), shiftKey));
    }

    private void onRecipeChanged(SkilledRecipe<?> recipe) {
        boolean crafting = false;
        this.clearFailedCheckMap();
        if (recipe != null) {
            ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
            if (recipe.canCraft((PlayerEntity)player)) {
                crafting = true;
            } else {
                this.populateFailedCheckMap(recipe.getFailedChecks((PlayerEntity)player));
            }
        }
        this.craftButton.field_230693_o_ = crafting;
    }

    private void clearFailedCheckMap() {
        this.failedChecks.clear();
    }

    private void populateFailedCheckMap(List<IRecipeCondition> conditions) {
        this.failedChecks = conditions;
    }
}

